/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.plugins.debug;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IBookmarkOverlay;
import mezz.jei.api.runtime.IIngredientFilter;
import mezz.jei.api.runtime.IIngredientListOverlay;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.plugins.debug.DebugRecipe;
import mezz.jei.common.plugins.debug.JeiDebugPlugin;
import mezz.jei.common.plugins.jei.ingredients.DebugIngredient;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3675;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_490;
import net.minecraft.class_746;

public class LegacyDebugRecipeCategory<F>
implements IRecipeCategory<DebugRecipe> {
    public static final class_2960 UID = new class_2960("jei", "legacy_debug");
    public static final int RECIPE_WIDTH = 160;
    public static final int RECIPE_HEIGHT = 60;
    private final IDrawable background;
    private final IPlatformFluidHelper<F> platformFluidHelper;
    private final class_2561 localizedName;
    private final IDrawable tankBackground;
    private final IDrawable tankOverlay;
    private final IDrawable item;
    private boolean hiddenRecipes;

    public LegacyDebugRecipeCategory(IGuiHelper guiHelper, IPlatformFluidHelper<F> platformFluidHelper) {
        this.background = guiHelper.createBlankDrawable(160, 60);
        this.platformFluidHelper = platformFluidHelper;
        this.localizedName = new class_2585("debug");
        class_2960 backgroundTexture = new class_2960("jei", "textures/gui/debug.png");
        this.tankBackground = guiHelper.drawableBuilder(backgroundTexture, 220, 196, 18, 60).addPadding(-1, -1, -1, -1).build();
        this.tankOverlay = guiHelper.drawableBuilder(backgroundTexture, 238, 196, 18, 60).addPadding(-1, -1, -1, -1).build();
        this.item = guiHelper.createDrawableIngredient(VanillaTypes.ITEM_STACK, new class_1799((class_1935)class_1802.field_17507));
    }

    @Override
    public class_2960 getUid() {
        return UID;
    }

    @Override
    public Class<? extends DebugRecipe> getRecipeClass() {
        return DebugRecipe.class;
    }

    @Override
    public class_2561 getTitle() {
        return this.localizedName;
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public IDrawable getIcon() {
        Textures textures = Internal.getTextures();
        return textures.getConfigButtonIcon();
    }

    @Override
    public void setIngredients(DebugRecipe recipe, IIngredients ingredients) {
        long bucketVolume = this.platformFluidHelper.bucketVolume();
        IIngredientTypeWithSubtypes<class_3611, F> fluidType = this.platformFluidHelper.getFluidIngredientType();
        F water = this.platformFluidHelper.create((class_3611)class_3612.field_15910, (int)((1.0 + Math.random()) * (double)bucketVolume));
        F lava = this.platformFluidHelper.create((class_3611)class_3612.field_15908, (int)((1.0 + Math.random()) * (double)bucketVolume));
        ingredients.setInputs(fluidType, List.of(water, lava));
        ingredients.setInput(VanillaTypes.ITEM_STACK, new class_1799((class_1935)class_1802.field_8600));
        ingredients.setInputLists(DebugIngredient.TYPE, List.of(List.of(new DebugIngredient(0), new DebugIngredient(1))));
        ingredients.setOutputs(DebugIngredient.TYPE, List.of(new DebugIngredient(2), new DebugIngredient(3)));
    }

    @Override
    public void draw(DebugRecipe recipe, class_4587 poseStack, double mouseX, double mouseY) {
        IJeiRuntime runtime = JeiDebugPlugin.jeiRuntime;
        if (runtime != null) {
            this.item.draw(poseStack, 50, 20);
            IIngredientFilter ingredientFilter = runtime.getIngredientFilter();
            class_310 minecraft = class_310.method_1551();
            minecraft.field_1772.method_1729(poseStack, ingredientFilter.getFilterText(), 20.0f, 52.0f, 0);
            IIngredientListOverlay ingredientListOverlay = runtime.getIngredientListOverlay();
            IIngredientManager ingredientManager = runtime.getIngredientManager();
            Collection<IIngredientType<?>> ingredientTypes = ingredientManager.getRegisteredIngredientTypes();
            for (IIngredientType<?> ingredientType : ingredientTypes) {
                Object ingredientUnderMouse = ingredientListOverlay.getIngredientUnderMouse(ingredientType);
                if (ingredientUnderMouse != null) {
                    LegacyDebugRecipeCategory.drawIngredientName(minecraft, poseStack, ingredientUnderMouse);
                    break;
                }
                IBookmarkOverlay bookmarkOverlay = runtime.getBookmarkOverlay();
                ingredientUnderMouse = bookmarkOverlay.getIngredientUnderMouse(ingredientType);
                if (ingredientUnderMouse == null) continue;
                LegacyDebugRecipeCategory.drawIngredientName(minecraft, poseStack, ingredientUnderMouse);
                break;
            }
        }
        class_4185 button = recipe.getButton();
        button.method_25394(poseStack, (int)mouseX, (int)mouseY, 0.0f);
    }

    private static <T> void drawIngredientName(class_310 minecraft, class_4587 poseStack, T ingredient) {
        IIngredientManager ingredientManager = JeiDebugPlugin.ingredientManager;
        if (ingredientManager != null) {
            IIngredientHelper<T> ingredientHelper = ingredientManager.getIngredientHelper(ingredient);
            String jeiUid = ingredientHelper.getUniqueId(ingredient, UidContext.Ingredient);
            minecraft.field_1772.method_1729(poseStack, jeiUid, 50.0f, 52.0f, 0);
        }
    }

    @Override
    public void setRecipe(IRecipeLayout recipeLayout, DebugRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (input) {
                tooltip.add(new class_2585(slotIndex + " Input itemStack"));
            } else {
                tooltip.add(new class_2585(slotIndex + " Output itemStack"));
            }
        });
        guiItemStacks.init(0, false, 70, 0);
        guiItemStacks.init(1, true, 110, 0);
        guiItemStacks.set(0, new class_1799((class_1935)class_1802.field_8705));
        guiItemStacks.set(1, Arrays.asList(new class_1799((class_1935)class_1802.field_8187), null));
        IGuiIngredientGroup<DebugIngredient> debugIngredientsGroup = recipeLayout.getIngredientsGroup(DebugIngredient.TYPE);
        debugIngredientsGroup.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (input) {
                tooltip.add(new class_2585(slotIndex + " Input DebugIngredient"));
            } else {
                tooltip.add(new class_2585(slotIndex + " Output DebugIngredient"));
            }
        });
        debugIngredientsGroup.init(0, true, 40, 0);
        debugIngredientsGroup.init(1, false, 40, 16);
        debugIngredientsGroup.init(2, false, 40, 32);
        debugIngredientsGroup.set(ingredients);
    }

    @Override
    public List<class_2561> getTooltipStrings(DebugRecipe recipe, double mouseX, double mouseY) {
        ArrayList<class_2561> tooltipStrings = new ArrayList<class_2561>();
        tooltipStrings.add((class_2561)new class_2585("Debug Recipe Category Tooltip is very long and going to wrap").method_27692(class_124.field_1065));
        if (recipe.checkHover(mouseX, mouseY)) {
            tooltipStrings.add((class_2561)new class_2585("button tooltip!"));
        } else {
            class_2585 debug = new class_2585("tooltip debug");
            tooltipStrings.add((class_2561)debug.method_27692(class_124.field_1067));
        }
        tooltipStrings.add((class_2561)new class_2585(mouseX + ", " + mouseY));
        return tooltipStrings;
    }

    @Override
    public boolean handleInput(DebugRecipe recipe, double mouseX, double mouseY, class_3675.class_306 input) {
        if (input.method_1442() != class_3675.class_307.field_1672) {
            return false;
        }
        class_4185 button = recipe.getButton();
        int mouseButton = input.method_1444();
        if (mouseButton == 0 && button.method_25402(mouseX, mouseY, mouseButton)) {
            IJeiRuntime runtime;
            class_310 minecraft = class_310.method_1551();
            class_746 player = minecraft.field_1724;
            if (player != null) {
                class_490 screen = new class_490((class_1657)player);
                minecraft.method_1507((class_437)screen);
            }
            if ((runtime = JeiDebugPlugin.jeiRuntime) != null) {
                IIngredientFilter ingredientFilter = runtime.getIngredientFilter();
                String filterText = ingredientFilter.getFilterText();
                ingredientFilter.setFilterText(filterText + " test");
                IRecipeManager recipeManager = runtime.getRecipeManager();
                if (!this.hiddenRecipes) {
                    recipeManager.hideRecipeCategory(VanillaRecipeCategoryUid.CRAFTING);
                    this.hiddenRecipes = true;
                } else {
                    recipeManager.unhideRecipeCategory(VanillaRecipeCategoryUid.CRAFTING);
                    this.hiddenRecipes = false;
                }
            }
            return true;
        }
        return false;
    }
}

